/*---------------------------------------------------------------------------*\

    FILE....: LOOPCID.CPP
    TYPE....: C++ program
    AUTHOR..: David Rowe
    DATE....: 10/5/01

    Plays a file on one channel, while sampling CID on another.  Used to test 
    CID.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "../src/vpbapi.h"
#include "../src/verbose.h"

void vpb_set_codec_reg(int chdev,            // channel handle
		       unsigned short addr,  // 8-bit address of codec register
		       unsigned short data   // 8-bit data to write to register
		      );

#define WAITING   0
#define FINISHED  1

int main(int argc, char * argv[])
{
	int	        hp,hr, ret, state;
	VPB_EVENT       e;
	int             bases[] = {0};
	char	        s[VPB_MAX_STR];

	if (argc != 5) {
		printf("usage: loopcid PlayCh[1..4] PlayWaveFile"
		       "RecCh[1..4] RecWaveFile\n");
		exit(0);
	}
	//verbose(1);
	vpb_seterrormode(VPB_DEVELOPMENT);

	vpb_config(1, bases, "/etc/vpb/vpbmain_pci.out", VPB_V4PCI);
	hp = vpb_open(1, atoi(argv[1]));
	hr = vpb_open(1, atoi(argv[3]));
	vpb_sethook_sync(hp, VPB_OFFHOOK);
	vpb_sethook_sync(hr, VPB_ONHOOK);

	vpb_play_file_async(hp, argv[2], 0);
	vpb_record_file_async(hr, argv[4], VPB_LINEAR);

	// wait for play file to finish

	state = WAITING;
	do {
		ret = vpb_get_event_ch_async(hp, &e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf(s);
			if (e.type == VPB_PLAYEND) {
				vpb_record_terminate(hr);
				state = FINISHED;
			}
		}	
			
		vpb_sleep(10);
	} while(state != FINISHED);
	
	vpb_sleep(1000);

	vpb_close(hp);

	return 0;
}



